1 SCREEN 12: REM en VGA 640x 480 puntos fic:manolo20.bas
REM programa para calculo del diagrama de radiacion de sistemas de antena apiladas
REM mediante composicion de antenas de paneles de dipolos
REM lenguaje basic, 1 version se ejecuta sobre MS-DOS qbasic 1.1,descarga en https://www.filehorse.com/es/descargar-qbasic/descargar/
REM version 20 se ejecuta con QB64, descarga en https://www.qb64.org/
REM manual de basic en http://www.geocities.ws/chorimovil/manualgwbasicarg/000.html
 REM CONSTANTES
 pi = 3.141516
 MaxX = 600: maxY = 440: ' coordenadas maximas
 offx = 20: offY = 20:  ' offset primer punto a dibujar
 offYv = 20: ' offset y vertical
 medx = offx + MaxX / 2: medy = offY + maxY / 2: ' calculo punto medio pantalla
 torx = 30: tory = 30: 'tamao torre
 inirad = 1 * torx: ' radio inicial del radial
 KP = 40: ' tamao panel, constante panel
 
2 CLS : LOCATE 18, 79:
PRINT "    DIAGRAMA DE RADIACION PARA TV Y FM ": PRINT
PRINT "      COPYRIGHT DE MANUEL JIMENEZ 1987 Primera Version BASIC ": PRINT
PRINT "        & FELIPE VIDAL 2009 Version QBASIC PC en XP": PRINT
PRINT "        (Version que genera fic .csv para -> .ant)"
GOSUB 8000: REM limpio linea 1
3 INPUT "DESCRIPCION:", D$
5 PRINT : INPUT " DESEA EXPLICACIONES (S/N):", e$: e$ = UCASE$(e$): ' mayusculas
6 IF e$ = "S" THEN GOSUB 1000: REM EXPLICACIONES
 GOSUB 12
7 IF e$ = "N" THEN GOTO 14
8 GOTO 5
9 REM poner limites y step en radianes input f1,f2,ff out f1a f2a ffa
 f1a = f1 / 180 * pi + .0001:  f2a = f2 / 180 * pi + .0001: ' inicio y fin en rad.
 ffa = ff / 180 * pi: ' el step eb radianes
10 RETURN

REM Opciones en largo
12 PRINT "Corrige h/Modi.v/Graba h/Diagram/Save v/Fin/Ayuda/Hor/Ver";
13 RETURN

14 REM ======================================================== bucle gral
15 REM pasada la parte de explicaciones
LOCATE 26, 1: 'v se omite para que grafico final salga bonito
IF e$ = "S" THEN GOSUB 12
LOCATE 29, 1: GOSUB 22: REM pedir opcion
CLS
'EmaxH = .5:  ' valor del campo maximo para calc.horizontal
   IF k$ = "H" THEN GOSUB 7000:  ' HACER hor.
   IF k$ = "A" THEN GOSUB 1000:  ' ayuda, EXPLICACIONES
   IF k$ = "V" THEN GOSUB 2000:  ' HACER vert.
   IF k$ = "C" THEN GOSUB 5000: GOSUB 7100: ' Corregir datos. HORIZ
   IF k$ = "M" THEN GOSUB 5500: GOSUB 2283: GOSUB 2050: ' Modi datos. VERTI
' EN VERTICAL SE REDIBUJAN TODOS CADA VEZ QUE SE MODIFICA UNO
   IF k$ = "G" THEN GOSUB 3000:  ' Grabar datos.hor
   IF k$ = "D" THEN GOSUB 3100:  ' diagrama .ant horizonatl
   IF k$ = "S" THEN GOSUB 3300:  ' SALVA datos VERT.
   IF k$ = "F" THEN GOTO 9950:  ' fin,SALIR DEL PROGRAMA
20 GOTO 14: ' bucle general programa

22 REM muestra Iniciales de opciones, pide k$ , la pasa a mayuscula
 INPUT "(c/g/d/H/F/A/V/m/s):"; k$: k$ = UCASE$(k$)
RETURN

26 REM ======================================================= bucle gral
30 ' proceso de calculo para diagrama horizontal .........................
35 ' hace bucle, en cada paso calcula ea,eb,ec y ed
40 ' si n.de paneles cara a,b,c o d es 0 -> no calcules su angulo fsa,fsb,fsc,fsd
80 FOR f = f1a TO f2a STEP ffa:
   GOSUB 500: 'calcular ea,eb,ec,ed
85 fsa = 0: fsb = 0: fsc = 0: fsd = 0: ' angulos del radial f con acimut de cada panel
95 IF na = 0 THEN GOTO 107
105 fsa = ABS(2 * pi * da * COS(tA - f)) + aa0
107 IF nb = 0 THEN GOTO 111
110 fsb = ABS(2 * pi * db * COS(tB - f)) + ab0
111 IF nc = 0 THEN GOTO 113
112 fsc = ABS(2 * pi * dc * COS(tC - f)) + ac0
113 IF nd = 0 THEN GOTO 115
114 fsd = ABS(2 * pi * dd * COS(td - f)) + ad0
115 'sumar componentes de cada cara
126 e1 = na * ea * COS(fsa) + nb * eb * COS(fsb) + nc * ec * COS(fsc) + nd * ed * COS(fsd)
128 e2 = na * ea * SIN(fsa) + nb * eb * SIN(fsb) + nc * ec * SIN(fsc) + nd * ed * SIN(fsd)
129 e = SQR(e1 * e1 + e2 * e2): x = e * SIN(f): y = e * COS(f)
LINE (x * s + offx + MaxX / 2, offY + maxY / 2 - y * s)-(x * s + offx + MaxX / 2, offY + maxY / 2 - y * s)
' dibuja un puntito
145 LOCATE 24, 1: PRINT INT(f * 180 / pi); ""
PRINT "e = "; e; ""
180 NEXT f
RETURN: ' ---------------------------------------------------------------

500 IF na = 0 GOTO 515: '         Calculo de ea,eb,ec,ed campos componentes panel a, b ,c y d
505 ga = f - (aar - pi / 2): '     de cada panel, para diag. HORIZONTAL
507 e1 = COS((pi / 2) * COS(ga)) / SIN(ga): e2 = 2 * SIN((pi / 2) * SIN(ga))
510 ea = ABS(e1) * e2: IF ea < 0 THEN ea = 0
515 IF nb = 0 GOTO 541
516 gb = f - (abr - pi / 2)
517 e1 = COS((pi / 2) * COS(gb)) / SIN(gb): e2 = 2 * SIN((pi / 2) * SIN(gb))
518 eb = ABS(e1) * e2: IF eb < 0 THEN eb = 0
541 IF nc = 0 GOTO 545
542 gc = f - (acr - pi / 2)
543 e1 = COS((pi / 2) * COS(gc)) / SIN(gc): e2 = 2 * SIN((pi / 2) * SIN(gc))
544 ec = ABS(e1) * e2: IF ec < 0 THEN ec = 0
545 IF nd = 0 GOTO 550
546 gd = f - (adr - pi / 2)
547 e1 = COS((pi / 2) * COS(gd)) / SIN(gd): e2 = 2 * SIN((pi / 2) * SIN(gd))
548 ed = ABS(e1) * e2: IF ed < 0 THEN ed = 0
550 RETURN: '..............................................

667  REM DIBUJO DE PANEL, PARAMETROS USADOS X,Y,A ,coordenadas y acimut
668 a = (90 - a): a = a / 180 * pi: 'en rad
' Estudio de giro de coordenadas
'    0,1 equivale a tener A=0
'     |\ 0.7,0.7          (0,1) -> (sen A, cos A)
'     | |             (0.7,0.7) -> (cos(45-A),sen (45-A))
' 0,0 + |            (0.7,-0.7) -> (cos(45+A),sen (45+A))
'     | |                (0,-1) -> (- sen A, - cos A)
'     |/ 0.7,0.7
'    0,-1
pox = medx + x * KP: poY = medy - y * KP
esX = KP / 2: ANG = pi / 4 - a: ANG2 = pi / 4 + a
COLOR 4
LINE (pox, poY)-(pox + esX * 1 * SIN(a), poY + esX * 1 * COS(a))
LINE (pox + esX * 1 * SIN(a), poY + esX * 1 * COS(a))-(pox + esX * 1 * COS(ANG), poY + esX * 1 * SIN(ANG))
LINE (pox + esX * 1 * COS(ANG), poY + esX * 1 * SIN(ANG))-(pox + esX * 1 * COS(ANG2), poY - esX * 1 * SIN(ANG2))
LINE (pox + esX * 1 * COS(ANG2), poY - esX * 1 * SIN(ANG2))-(pox - esX * 1 * SIN(a), poY - esX * 1 * COS(a))
LINE (pox - esX * 1 * SIN(a), poY - esX * 1 * COS(a))-(pox, poY)
COLOR 15
730 RETURN: '..................................................

1000 REM 2 paginas de ayuda
GOSUB 1005: GOSUB 1007
1004 RETURN


1005 CLS : REM primara pagina ayuda
PRINT "Este programa permite obtener y dibujar el diagrama de radiacion"
PRINT " de un sistema compuesto por 8 pisos; de 4 caras, como maximo,"
PRINT "de paneles radiantes de las bandas de TV y FM. "
PRINT " El diagrama que se obtiene es relativo, esto es , indica "
PRINT " la ganancia respecto a la direccion de maxima radiacion"
PRINT " el valor absoluto de dicha ganancia es facilmente obtenible"
PRINT " del fabricante de dichos paneles":
PRINT "El programa usa para el calculo , la expresion"
PRINT "analitica de un panel elemental. Esto es un dipolo de media"
PRINT " onda , situado a un cuarto de onda de un plano reflector."
PRINT " Las leves diferencias que puedan observarse entre este programa"
PRINT " y los datos del fabricante, son debidos a que por consideraciones"
PRINT " practicas ( Ganancia, Ancho de banda, R.O.E. los paneles"
PRINT " de los fabricantes no se pueden considerar iguales a los de este"
PRINT "programa."
PRINT " Los datos de entrada se han elegido para que sean didacticos"
PRINT " P.E. para la separacion entre paneles se usan longitudes de onda"
PRINT " , en vez de milimetros, por este motivo."
PRINT " Los acimut y desfasajes se deben dar en grados sexagesimales."
PRINT " Ahora presento la torre, y el sistema de coordenadas escogido"
PRINT " para la acotacion de los paneles en el plano horizontal."
PRINT
PRINT " En el plano vertical , se supone que los paneles estan alineados"
PRINT "vertical y paralelamente al eje de la torre y a la misma distancia"
PRINT "unos de otros"
PRINT " Los posibles retranqueos deben expresarse en grados, y deben "
PRINT "sumarse a los desfasajes electricos correspondientes"
INPUT k$: REM da intro
RETURN



1007 CLS : REM segunda pagina ayuda
PRINT " El piso 1 es el superior,el piso que no exista queda eliminado"
PRINT "dando un valor de angulo de fase en blanco."
PRINT "                       |y                      "
PRINT "                       |                       "
PRINT "                       | A                     "
PRINT "                   ----------                  "
PRINT "                   |   |    |                  "
PRINT "    -x           D |   |    |B              x  "
PRINT "    ---------------|---|----|----------------  "
PRINT "                   |   |    |                  "
PRINT "                   |   |    |                  "
PRINT "                   ----------                  "
PRINT "                       |C                      "
PRINT "                       |                       "
PRINT "                       |                       "
PRINT "                       |-y                     "
PRINT "  Este programa se basa en la adicion de campos fasoriales,es decir"
PRINT " en sumar las contribuciones de campo de cada uno de los  paneles."
PRINT " La magnitud del campo (el campo es un vector), se considera constante"
PRINT " en funcion de la distancia (aunque sabemos que se atenua con la dist.)"
PRINT " porque lo importante es la suma de todos los paneles."
PRINT "  En un punto distante a mas de una decena de longitudes de onda, el campo"
PRINT " aportado por cada panel, (es vector con modulo y fase), separados a "
PRINT " menos de una landa, ya se pueden considerar en un mismo punto,"
PRINT " (manteniendo la relacion de potencias), en la suma "
PRINT " el efecto importante es la diferencia de fase entre cada panel,"
PRINT " para ello en cada punto estudiamos la aportacion segun su fase."
PRINT "Opciones";
GOSUB 12
INPUT k$: REM intro
1008 RETURN: ' .........................................................



1009 ' dibuja Cuadros , torre y circulo inicial ..........................
'LOCATE 1, 1: PRINT " Diagrama Horizontal":
1010 : 'dibujar parte cuadrados
GOSUB 6100: ' Recuadro exterior
GOSUB 6200: ' dibujo torre
k = 0
COLOR 3
1015 FOR v = 0 TO 2 * pi STEP 10 / 180 * pi: ' Dibujo de los radiales
PoseX = offx + MaxX / 2: poseY = offY + maxY / 2
xinit = PoseX + inirad * SIN(v)
yinit = poseY - inirad * COS(v)
xfin = PoseX + maxY / 2 * SIN(v)
yfin = poseY - maxY / 2 * COS(v)
LINE (xinit, yinit)-(xfin, yfin), 3, , &HFF00
'pasar de coordenadas vga a coordenadas caracter, 230,0 -> 0,40
xfi = 80 * xfin / 640 - 1
yfi = 30 * yfin / 480
IF k > 175 THEN xfi = xfi - 1
LOCATE yfi, xfi
 PRINT k;  'poner numero del radial
k = k + 10
1019 NEXT v
micolor = 5
FOR v = 1 TO 10: ' Dibujo de circulos concentricos
 IF v = 7 THEN micolor = 6 ELSE micolor = 5: ' 7 circulo es el de .5
 CIRCLE (offx + MaxX / 2, offY + maxY / 2), maxY / 2 / 10 * v, micolor
NEXT v
COLOR micolor: ' en orden circle se determina al final
LOCATE 15, 14: PRINT "1   .8    .6   .4   .2  "
COLOR 15:
RETURN: '..............................................

1095 : ' entrada datos paneles ..........................
1100 CLS : 'pedir datos de todos los paneles
GOSUB 1110: 'datos A
GOSUB 1150: 'datos D
GOSUB 1200: 'datos C
GOSUB 1250: 'datos D
RETURN: '..............................................

1045 ' PRESENTAR DATOS DE PANEL A
LOCATE 3, 1: PRINT " na="; na
 IF na = 0 THEN GOTO 1048
 LOCATE 4, 1: PRINT "xa="; xa
 LOCATE 5, 1: PRINT "ya="; ya
 LOCATE 6, 1: PRINT "aa="; aa
 x = xa: xa = x + .0001
 y = ya: ya = y + .0002
 a = aa: aar = aa / 180 * pi: ' acimut en radianes
 tA = 3 * pi / 2 - ATN(ya / xa): 'angulo
 da = SQR(ya * ya + xa * xa): aa0 = 0: ' distancia eje central panel A
 GOSUB 667: ' parametros usados x,y,A
1048 : RETURN: '................

1110 REM pedir datos panel A ..................................
GOSUB 8000: ' limpieza linea 1
1111 INPUT "Numero de paneles de cara A: ", na
1112 IF na = 0 THEN GOTO 1149
1120 GOSUB 8000: INPUT "Coordenada x  del  panel  A:"; xa
1130 GOSUB 8000: INPUT "Coordenada y  del  panel  A:"; ya
1140 GOSUB 8000: INPUT "Acimut de soporte de cara A con Norte:"; aa
1149 GOSUB 1045: RETURN:  ' ..................................

1050 ' PRESENTAR DATOS DE PANEL B .....................
 LOCATE 7, 1: PRINT " nb="; nb
 IF nb = 0 THEN GOTO 1099
 LOCATE 8, 1: PRINT "xb="; xb
 x = xb: xb = x + .0003
 LOCATE 9, 1: PRINT "yb="; yb
 y = yb: yb = y + .0004
 LOCATE 10, 1: PRINT "ab="; ab: a = ab
 LOCATE 11, 1: PRINT "aba="; aba
 abr = ab / 180 * pi: tB = 3 * pi / 2 - ATN(yb / xb)
 db = SQR(yb * yb + xb * xb): ab0 = aba / 180 * pi
 GOSUB 667: ' dibuja panel x,y,A
1099  RETURN: ' .............

1150 GOSUB 8000: ' limpia linea 1 pedir datos panel B
INPUT "Numero de paneles de la cara B:", nb
IF nb = 0 THEN GOTO 1199
 GOSUB 8000: INPUT "Coordenada x del panel B:"; xb
 GOSUB 8000: INPUT "Coordenada y del panel B:"; yb
 GOSUB 8000: INPUT "acimut  de la cara B con Norte:"; ab
 GOSUB 8000: INPUT "Desfasaje electrico de la cara B respecto A:"; aba
1199 GOSUB 1050: RETURN: '....................................

1278 : ' PRESENTAR DATOS DE PANEL C
 LOCATE 12, 1: PRINT " nC="; nc
IF nc = 0 THEN GOTO 1279
 LOCATE 13, 1: PRINT "xC="; xc
 x = xc: xc = x + .0005
 LOCATE 14, 1: PRINT "yC="; yc
 y = yc: yc = y + .0006
 LOCATE 15, 1: PRINT "aC="; ac: a = ac
 LOCATE 16, 1: PRINT "aCa="; aca
 acr = ac / 180 * pi: tC = 3 * pi / 2 - ATN(yc / xc)
 dc = SQR(yc * yc + xc * xc): ac0 = aca / 180 * pi
 GOSUB 667: ' dibuja panel x,y,A
1279  RETURN: '..............
1200 GOSUB 8000: INPUT "Numero de paneles de la cara C:", nc
 IF nc = 0 THEN GOTO 1249
 GOSUB 8000: INPUT "Coordenada x del panel C:"; xc
 GOSUB 8000: INPUT "Coordenada y del panel C:"; yc
 GOSUB 8000: INPUT "acimut  de la cara C con Norte:"; ac
 GOSUB 8000: INPUT "Desfasaje electrico de la cara C respecto A:"; aca
1249 GOSUB 1278: RETURN: '.........................................

1268 : ' PRESENTAR DATOS DE PANEL D
 LOCATE 17, 1: PRINT " nD="; nd
 IF nd = 0 THEN GOTO 1269
 LOCATE 18, 1: PRINT "xD="; xd
 x = xd: xd = x + .0001: '???
 LOCATE 19, 1: PRINT "yD="; yd
 y = yd: yd = y + .0001
 LOCATE 20, 1: PRINT "aD="; AD: a = AD
 LOCATE 21, 1: PRINT "aDa="; ada
 adr = AD / 180 * pi: td = 3 * pi / 2 - ATN(yd / xd)
 dd = SQR(yd * yd + xd * xd): ad0 = ada / 180 * pi
 GOSUB 667: ' dibuja panel x,y,A
1269  RETURN: '..............
1250 GOSUB 8000: INPUT "Numero de paneles de la cara D:", nd
 IF nd = 0 THEN GOTO 1300
 GOSUB 8000: INPUT "Coordenada x del panel D:"; xd
 GOSUB 8000: INPUT "Coordenada y del panel D:"; yd
 GOSUB 8000: INPUT " Acimut  de la cara D con Norte:"; AD: a = AD
 GOSUB 8000: INPUT "Desfasaje electrico de la cara D respecto A:"; ada
1300 GOSUB 1268: RETURN: ' -----------------------------------------------

3000 REM grabar datos en archivo .HOR +++++++++++++++++++++++++++++++++
GOSUB 8000: INPUT " nombre archivo HOR:"; nom$
 OPEN nom$ FOR OUTPUT AS #1
 PRINT #1, D$: ' descripcion del archivo
 PRINT #1, "N": ' no ayuda
 PRINT #1, "H": ' horizontal
 PRINT #1, na: IF na = 0 THEN GOTO 3010
 PRINT #1, xa: PRINT #1, ya: PRINT #1, aa
3010 PRINT #1, nb: IF nb = 0 THEN GOTO 3020
 PRINT #1, xb: PRINT #1, yb: PRINT #1, ab: PRINT #1, aba
3020 PRINT #1, nc: IF nc = 0 THEN GOTO 3030
 PRINT #1, xc: PRINT #1, yc: PRINT #1, ac: PRINT #1, aca
3030 PRINT #1, nd: IF nd = 0 THEN GOTO 3040
 PRINT #1, xd: PRINT #1, yd: PRINT #1, AD: PRINT #1, ada
3040 : CLOSE #1
RETURN: ' -------------------------------------------------------

3100 REM graba diagrama horizontal en .csv -> excel
GOSUB 8000: INPUT " nombre archivo HOR:"; nom$
 OPEN nom$ FOR OUTPUT AS #1
 PRINT #1, "Radial;campo;pot;db;"; : ' nombre campos
 PRINT #1, D$: ' descripcion del archivo
 'presupongo ya hecho diagrama,->calculado emaxH
IF EmaxH < .2 THEN INPUT " haz primero diagrama ", h$: GOTO 3110
 FOR i = 0 TO 360 STEP 10
  f = i / 180 * pi + .0001: 'radianes
  GOSUB 500: ' calcula ea,e,ec y ed
  fsa = 0: fsb = 0: fsc = 0: fsd = 0
  IF na <> 0 THEN fsa = ABS(2 * pi * da * COS(tA - f)) + aa0
  IF nb <> 0 THEN fsb = ABS(2 * pi * db * COS(tB - f)) + ab0
  IF nc <> 0 THEN fsc = ABS(2 * pi * dc * COS(tC - f)) + ac0
  IF nd <> 0 THEN fsd = ABS(2 * pi * dd * COS(td - f)) + ad0
  REM si na=0 no importa ni ea ni fsa, multiplica x 0
  e1 = na * ea * COS(fsa) + nb * eb * COS(fsb) + nc * ec * COS(fsc) + nd * ed * COS(fsd)
  e2 = na * ea * SIN(fsa) + nb * eb * SIN(fsb) + nc * ec * SIN(fsc) + nd * ed * SIN(fsd)
  k = e1 * e1 + e2 * e2: e = SQR(k)
  PRINT #1, USING "###"; i;
  PRINT #1, ";"; e; ";"; k; ";";
  IF k < .0001 THEN lo = -40 ELSE lo = 10 * LOG(k / EmaxH / EmaxH) / 2.3: 'son neperianos
  PRINT #1, USING "###.#"; lo
'  PRINT e; k; lo: rem depuracion
 NEXT i
CLOSE #1
3110 : RETURN: ' -------------------------------------------------------

3300 : ' grabar datos en archivo VER
GOSUB 8000: INPUT " Nombre archivo VER:"; nomv$
 OPEN nomv$ FOR OUTPUT AS #1
 PRINT #1, D$: ' descripcion del archivo
 PRINT #1, "N": ' no ayuda
 PRINT #1, "V": ' horizontal
 PRINT #1, D
 IF a1 <> -100 THEN PRINT #1, a1 ELSE PRINT #1,
 IF a2 <> -100 THEN PRINT #1, a2 ELSE PRINT #1,
 IF a3 <> -100 THEN PRINT #1, a3 ELSE PRINT #1,
 IF a4 <> -100 THEN PRINT #1, a4 ELSE PRINT #1,
 IF a5 <> -100 THEN PRINT #1, a5 ELSE PRINT #1,
 IF a6 <> -100 THEN PRINT #1, a6 ELSE PRINT #1,
 IF a7 <> -100 THEN PRINT #1, a7 ELSE PRINT #1,
 IF a8 <> -100 THEN PRINT #1, a8 ELSE PRINT #1,

 CLOSE #1
RETURN: ' -------------------------------------------------------

2000
'CLS : LOCATE 1, 1: PRINT "Vertical"
GOSUB 2250: REM entrada de datos
2050 GOSUB 6100: REM dibujo recuadro
'LOCATE 1, 1: INPUT "INCREMENTO DECLINACION,TT=", TT
tt = .1: '.5: ' depuracion ---
LOCATE 13, 5: PRINT "TT="; tt: ttr = tt * pi / 180
GOSUB 2600: REM calculo emaxV,eminV campo maximo/minimo en vertical
GOSUB 2500: REM dibuja escala
'LOCATE 1, 1: INPUT "DESDE UN ANGULO,T1=", T1
t1 = 90 + inicio: '88: '-2 +++
LOCATE 11, 5: PRINT "T1="; t1: t1R = t1 * pi / 180
'LOCATE 1, 1: INPUT "HASTA UN ANGULO,T2=", t2
t2 = 90 + fin: ' 108: '18
LOCATE 12, 5: PRINT "T2="; t2: t2R = t2 * pi / 180
'LOCATE 1, 1: INPUT "FACTOR DE ESCALA,S=", s
s = INT(maxY / EmaxV)
LOCATE 14, 5: PRINT "S="; s
     LOCATE 3, 45: PRINT D$;
     LOCATE 20, 5: PRINT "EMax="; EmaxV; " en "; tmaxv; ""
     LOCATE 21, 5: PRINT "EMin="; eminV; " en "; tminV; ""
     GOSUB 2100: REM proceso de calculo
GOSUB 8050
RETURN: ' ........................................................

2100 : ' proceso de calculo del diagrama vertical
' podemos realizarla entre -3 y 18(min en t=3) y entre 0 y 40 ( min en 30)
FOR t = t1R + .0001 TO t2R STEP ttr
 GOSUB 2200: ' calcula para cada t,[ d,air] y da ET
  y = ET
  x = t / pi * 180
 LOCATE 18, 5: PRINT "run T="; INT(x); "e="; y;
 PoseX = offx + (t - t1R) * MaxX / (t2R - t1R)
 poseY = offYv + maxY - y / EmaxV * maxY
 LINE (PoseX, poseY)-(PoseX, poseY): ' puntito
 NEXT t: 'bucle
RETURN: '....................................................

2200 : 'rutina calculo para vertical, INPUT: t,D,a1r,a2r,...a8r, OUT: ET
ksuma = pi * D * COS(pi - t)
EP = ABS(SIN(2 * pi * COS(t)) / SIN((pi / 2) * COS(t)))
f1 = 0: f2 = 0: F3 = 0: F4 = 0: F5 = 0: F6 = 0: F7 = 0: F8 = 0
S1 = 0: S2 = 0: S3 = 0: S4 = 0: S5 = 0: S6 = 0: S7 = 0: S8 = 0: ' a1=-100 ->entrada blanco
IF a1 <> -100 THEN FS1 = 2 * ksuma + a1r: S1 = SIN(FS1): f1 = COS(FS1)
IF a2 <> -100 THEN FS2 = 4 * ksuma + a2r: S2 = SIN(FS2): f2 = COS(FS2)
IF a3 <> -100 THEN FS3 = 6 * ksuma + a3r: S3 = SIN(FS3): F3 = COS(FS3)
IF a4 <> -100 THEN FS4 = 8 * ksuma + a4r: S4 = SIN(FS4): F4 = COS(FS4)
IF a5 <> -100 THEN FS5 = 10 * ksuma + a5r: S5 = SIN(FS5): F5 = COS(FS5)
IF a6 <> -100 THEN FS6 = 12 * ksuma + a6r: S6 = SIN(FS6): F6 = COS(FS6)
IF a7 <> -100 THEN FS7 = 14 * ksuma + a7r: S7 = SIN(FS7): F7 = COS(FS7)
IF a8 <> -100 THEN FS8 = 16 * ksuma + a8r: S8 = SIN(FS8): F8 = COS(FS8)
     TODOS = (S1 + S2 + S3 + S4 + S5 + S6 + S7 + S8)
     TODOf = f1 + f2 + F3 + F4 + F5 + F6 + F7 + F8
     e = ABS(EP * SQR(TODOS * TODOS + TODOf * TODOf)): ' campo e
     R = ABS(2 * SIN(2 * pi * .25 * SIN(t)))
     ET = e * R: ' e total
RETURN: '......................................................

2250 ' peticion datos vertical
GOSUB 2300: 'PIDE D
a1r = -100: a2r = -100: a3r = -100: a4r = -100: a5r = -100: a6r = -100
a7r = -100: a8r = -100
IF D = 0 THEN 2255
GOSUB 2310: ' PIDE A1
GOSUB 2320: ' pide A2
GOSUB 2330: ' pide A3
GOSUB 2340
GOSUB 2350
GOSUB 2360
GOSUB 2370
GOSUB 2380: ' PIDE A8
GOSUB 2283: ' PRESENTA DATOS VERT.
2255 : RETURN: ' ..............................

2283 : 'PRESENTA DATOS VERTICAL
LOCATE 2, 4: PRINT "D="; D
LOCATE 3, 4: m$ = "A1=": N = a1: GOSUB 9800: ' usa n$ y n
LOCATE 4, 4: m$ = "A2=": N = a2: GOSUB 9800
LOCATE 5, 4: m$ = "A3=": N = a3: GOSUB 9800
LOCATE 6, 4: m$ = "A4=": N = a4: GOSUB 9800
LOCATE 7, 4: m$ = "A5=": N = a5: GOSUB 9800
LOCATE 8, 4: m$ = "A6=": N = a6: GOSUB 9800
LOCATE 9, 4: m$ = "A7=": N = a7: GOSUB 9800
LOCATE 10, 4: m$ = "A8=": N = a8: GOSUB 9800
RETURN: '..................

2300 LOCATE 2, 25: INPUT "Ver.Distancia entre PISOS,(en Long.de onda,D=", D:
RETURN: ' no puedes hacerlo con 9900 tiene decimales

2310  m$ = "ANGULO DE FASE DEL PISO 1, A1=": GOSUB 9900: a1r = N
a1 = Ng: RETURN: '...

2320  m$ = "ANGULO DE FASE DEL PISO 2, A2=": GOSUB 9900: a2r = N
a2 = Ng: RETURN: '......

2330  m$ = "ANGULO DE FASE DEL PISO 3, A3=": GOSUB 9900: a3r = N
a3 = Ng: RETURN: '......

2340 m$ = "ANGULO DE FASE DEL PISO 4, A4=": GOSUB 9900: a4r = N
a4 = Ng: RETURN: '......

2350  m$ = "ANGULO DE FASE DEL PISO 5, A5=": GOSUB 9900: a5r = N
a5 = Ng: RETURN: '......

2360  m$ = "ANGULO DE FASE DEL PISO 6, A6=": GOSUB 9900: a6r = N
a6 = Ng: RETURN: '......

2370  m$ = "ANGULO DE FASE DEL PISO 7, A7=": GOSUB 9900: a7r = N
a7 = Ng: RETURN: '......

2380  m$ = "ANGULO DE FASE DEL PISO 8, A8=": GOSUB 9900: a8r = N
a8 = Ng: RETURN: '......

2430 RETURN: ' ..................................................

2500 REM DIBUJA ESCALA en pantalla
k = 0:  LOCATE 1, 1: PRINT "EJE Y |E|/|Emax|";
FOR y = 0 TO 100 STEP 10: ' 10 saltos en eje y de 10 %, lineas horizo.
poseY = offY + y * maxY / 100: k = k + 1
 LINE (offx, poseY)-(offx + MaxX, poseY), 3, , &HFF00
 LOCATE INT(k * 2.7), 1: PRINT USING "##"; 100 - y;
 LOCATE INT(k * 2.7), 75
 mipor = (100 - y) / 100
 IF mipor > 0 THEN milog = -20 * LOG(mipor) / 2.3 ELSE milog = 50
 PRINT USING "##.#"; milog;
NEXT y:
k = 0: LOCATE 3, 76: PRINT "db";
inicio = 0: fin = 39: paso = 2: ' un solo panel
IF D = 0 THEN GOTO 2510
IF EmaxV > 10 THEN inicio = -2: fin = 18: paso = 1: 'varios paneles vert.
2510
FOR x = inicio TO fin STEP paso: ' 20 saltos en eje x en intervalo col.vert.
PoseX = offx + (x - inicio) / (fin - inicio) * MaxX: '20
 LINE (PoseX, offY)-(PoseX, offY + maxY), 3, , &HFF00
 LOCATE 28, INT(k * 3.7 + 3): PRINT x; : k = k + 1
NEXT x:
LOCATE 29, 29: PRINT "EJE X:  DESVIADO AL VALOR MAX.";
'INPUT "kk", kk: rem depuracion
2590 RETURN: ' ..................................................

2600 : ' proceso de calculo del e maximo en vertical OUT: emaxv, tmaxv
EmaxV = 0: eminV = 1000
fk = .1 * pi / 180: ' valor usado como entrada nula
FOR t = 8 / 18 * pi TO 13 / 18 * pi STEP ttr: ' t1R + .0001 TO t2R STEP ttr
 GOSUB 2200: ' calcula para t,d,fk y da ET
 IF EmaxV < ET THEN EmaxV = ET: tmaxv = CINT(t / pi * 180) - 90
 IF eminV > ET THEN eminV = ET: tminV = CINT(t / pi * 180) - 90
 NEXT t: 'bucle
RETURN: '....................................................

5000 REM CORRECION ENTRADA DE DATOS horizontal
GOSUB 8000: PRINT "HORIZONTAL (NA,NB,NC,ND,TODO,NADA) ";
INPUT "DESEA CAMBIAR DATOS"; k$
k$ = UCASE$(k$)
IF k$ = "NADA" THEN GOTO 5009:  'SALIR
IF k$ = "TODO" THEN GOSUB 1100:
IF k$ = "NA" THEN GOSUB 1110:
IF k$ = "NB" THEN GOSUB 1150:
IF k$ = "NC" THEN GOSUB 1200:
IF k$ = "ND" THEN GOSUB 1250:
GOTO 5000
5009 '  EMPIEZA A PRESENTAR DATOS
GOSUB 1045: ' PRESENTA A
GOSUB 1050: ' PRESENTA B
GOSUB 1278: ' PRESENTA C
GOSUB 1268: ' PRESENTA D
5510 RETURN: '----------------------------------------------

5500 : ' modificacion datos vertical
GOSUB 8000: PRINT "VERTICAL (TODO,D,A1,A2,A3,A4,A5,A6,A7,A8,NADA) ";
INPUT "DESEA CAMBIAR "; k$: k$ = UCASE$(k$)
IF k$ = "NADA" THEN RETURN:  ' EMPIEZA A CALCULAR
IF k$ = "TODO" THEN GOSUB 2250:
IF k$ = "D" THEN GOSUB 2300:
IF k$ = "A1" THEN GOSUB 2310:
IF k$ = "A2" THEN GOSUB 2320:
IF k$ = "A3" THEN GOSUB 2330:
IF k$ = "A4" THEN GOSUB 2340:
IF k$ = "A5" THEN GOSUB 2350:
IF k$ = "A6" THEN GOSUB 2360:
IF k$ = "A7" THEN GOSUB 2370:
IF k$ = "A8" THEN GOSUB 2380:
GOTO 5500
RETURN: '----------------------------------------------

6100 : ' Recuadro exterior
     LINE (offx + 0, offY + 0)-(offx + MaxX, offY + 0):
     LINE (offx + MaxX, offY + 0)-(offx + MaxX, offY + maxY)
     LINE (offx + MaxX, offY + maxY)-(offx + 0, offY + maxY):
     LINE (offx + 0, offY + maxY)-(offx + 0, offY + 0):
RETURN: '----------------------------------------------

6200 REM dibujo de torre
COLOR 2
LINE (medx - torx / 2, medy - tory / 2)-(medx + torx / 2, medy - tory / 2)
LINE (medx + torx / 2, medy - tory / 2)-(medx + torx / 2, medy + tory / 2)
LINE (medx + torx / 2, medy + tory / 2)-(medx - torx / 2, medy + tory / 2)
LINE (medx - torx / 2, medy + tory / 2)-(medx - torx / 2, medy - tory / 2)
COLOR 15
RETURN: '----------------------------------------------

7000 ' rutina para diagrama horizontal
CLS
GOSUB 1100: ' Pedir datos de partida diagrama hor.
7100  f1 = 0: f2 = 360: ff = 1: '1 definitivo, 10 para depuracion
GOSUB 1009: ' dibuja Cuadros , torre y circulo inicial
GOSUB 8000: ' Limpia linea 1
PRINT D$; : ' Saca la Descripcion del diagrama
GOSUB 9000: ' calcula campo maximo
s = INT(maxY / 2 / EmaxH): 'FACTOR DE ESCALA  DEL DIAGRAMA
LOCATE 22, 1: PRINT "Escala S="; s
PRINT " Emax="; EmaxH;
GOSUB 30:   ' Proceso de calculo diagrama hor.
IF MID$(D$, 1, 1) = "$" THEN GOTO 9950
REM 9950 es salir del prog.
GOSUB 8050: REM intro
7050 : RETURN: '................................................

8000  REM rutina para limpiar linea 1
LOCATE 1, 1: PRINT SPACE$(79): LOCATE 1, 1: ' limpia linea 1
RETURN:  '................................................

8050 REM espera intro
PRINT "<-|":
SLEEP
a$ = INKEY$: REM 13 es Return , 27 Esc
PRINT a$
REM IF a$ <> CHR$(27) THEN GOTO 8050
8055 RETURN

9000 : ' rutina para calculo del campo maximo diag. horizontal
 f1a = f1 / 180 * pi + .0001:  f2a = f2 / 180 * pi + .0001:
ffa = ff / 180 * pi
EmaxH = 0
FOR f = f1a TO f2a STEP ffa
 GOSUB 500: ' calcula ea,e,ec y ed
 fsa = 0: fsb = 0: fsc = 0: fsd = 0
 IF na <> 0 THEN fsa = ABS(2 * pi * da * COS(tA - f)) + aa0
 IF nb <> 0 THEN fsb = ABS(2 * pi * db * COS(tB - f)) + ab0
 IF nc <> 0 THEN fsc = ABS(2 * pi * dc * COS(tC - f)) + ac0
 IF nd <> 0 THEN fsd = ABS(2 * pi * dd * COS(td - f)) + ad0
 REM si na=0 no importa ni ea ni fsa, multiplica x 0
 e1 = na * ea * COS(fsa) + nb * eb * COS(fsb) + nc * ec * COS(fsc) + nd * ed * COS(fsd)
 e2 = na * ea * SIN(fsa) + nb * eb * SIN(fsb) + nc * ec * SIN(fsc) + nd * ed * SIN(fsd)
 e = SQR(e1 * e1 + e2 * e2)
 IF e > EmaxH THEN EmaxH = e
NEXT f
RETURN: '...............................................................

9800  ' rutina de presentacion de datos, input m$,N
PRINT m$; : IF N <> -100 THEN PRINT N;
RETURN: '...............................................................

9900 ' RUTINA PARA ENTRADA DE INTRO-> NUMEROS, print M$, input k$, salida en N,ng
GOSUB 8000: 'limpia linea 1
9500 PRINT m$; : INPUT k$
N = -100: IF k$ <> "" THEN Ng = VAL(k$): N = Ng / 180 * pi: GOTO 9700
Ng = -100: ' cuando dan blanco Ng y N =-100
9700  RETURN: '.........................

9950 REM salir del programa
PRINT "Fin programa."
SYSTEM

